/******************************************************************************
 * The following code was generated by the mental mill(R)                     *
 * code generator gen_fx, build 138747.21028
 *                                                                            *
 * Portions Copyright (c) 1986-2011 mental images GmbH, Berlin, Germany.      *
 ******************************************************************************/

// Option settings:
//	annotation_map : default.axml
//	depth_test : false
//	depth_write : false
//	directx_version : 9
//	flip_tex2d_v : false
//	format : HLSL
//	fragment_shader_profile : ps_3_0
//	fx_header : #ifdef _MAX_...
//	generate_sampler_states : true
//	generate_texture_parameters : true
//	pass_annotations : string Script = "Draw=Buffer;";
//	screen_space_vertices : true
//	shader_name : max_ToneOpLog_1
//	shader_type : surface
//	technique_annotations : string Script = "Pass=P0;";
//	vertex_shader_profile : vs_3_0

#ifdef _MAX_
string ParamID = "0x003";
#endif

float Script : STANDARDSGLOBAL <
	string UIWidget = "none";
	string ScriptClass = "scene";
	string ScriptOutput = "color";
	string Script = "Technique=T0";
> = 0.8; // version #

struct State {
    float4 tex_coord[4];
    float3 position;
    float3 origin;
    float3 normal;
    float3 direction;
    float ray_length;
};

#ifndef __LIGHT_TYPES
#define __LIGHT_TYPES
//
// Values for the light_type parameter of light shaders
//
#define LIGHT_POINT    0
#define LIGHT_SPOT     1
#define LIGHT_INFINITE 2
#define LIGHT_PLANAR   3

#endif // __LIGHT_TYPES

#ifndef __LIGHT_ITERATOR_STRUCT
#define __LIGHT_ITERATOR_STRUCT
struct Light_iterator {
    float3 msl_point;
    float3 msl_direction;
    float  msl_distance;
    float  msl_dot_nl;
    float3 msl_contribution;
    float3 msl_raw_contribution;
    float3 msl_shadow;
    int    msl_count;
};
#endif // __LIGHT_ITERATOR_STRUCT

#ifndef __FLOAT2_CTOR
#define __FLOAT2_CTOR
float2 __float2_ctor(float v)
{
    return v.xx;
}

#endif // __FLOAT2_CTOR

#ifndef __FLOAT3_CTOR
#define __FLOAT3_CTOR
float3 __float3_ctor(float v)
{
    return v.xxx;
}

#endif // __FLOAT3_CTOR

#ifndef __FLOAT4_CTOR
#define __FLOAT4_CTOR
float4 __float4_ctor(float v)
{
    return v.xxxx;
}

#endif // __FLOAT4_CTOR

#ifndef __DIFFERENTIAL_SCALE
#define __DIFFERENTIAL_SCALE
uniform float __differential_scale = 1.0;

#endif // __DIFFERENTIAL_SCALE

#ifndef __RASTER_OFFSET
#define __RASTER_OFFSET
uniform float2 __raster_offset = float2(0,0);

#endif // __RASTER_OFFSET

#ifndef __GRID_SNAP_2D
#define __GRID_SNAP_2D

float2 _grid_snap(float4 props, float2 coord)
{
    return (floor(props.xy * coord) + 0.5) / props.xy;
}

#endif // __GRID_SNAP_2D

#ifndef __TEXTURE2D
#define __TEXTURE2D

float4 __tex2D(sampler2D tex, float2 coord)
{
    return tex2D(tex, coord,
                   __differential_scale * ddx(coord),
                   __differential_scale * ddy(coord));
}

float4 __tex2D(sampler2D tex, float2 coord,float2 coord_dx, float2 coord_dy)
{
    return tex2D(tex, coord, coord_dx, coord_dy);
}

float4 __tex2D(sampler2D tex, float4 props, float2 coord, float2 blur)
{
    return tex2D(tex, coord,
                   __differential_scale * ddx(coord) * blur,
                   __differential_scale * ddy(coord) * blur);
}

float4 __tex2D(sampler2D tex, float4 props, float2 coord, float2 blur, int filter)
{
    if(filter == 6)
        return tex2D(tex, _grid_snap(props, coord),
                       float2(0.0,0.0),
                       float2(0.0,0.0));
    else
        return tex2D(tex, coord,
                   __differential_scale * ddx(coord) * blur,
                   __differential_scale * ddy(coord) * blur);
}

float4 __tex2D(sampler2D tex, float4 props, float2 coord, float2 coord_dx, float2 coord_dy, float2 blur)
{
    return tex2D(tex, coord,
                   coord_dx * blur,
                   coord_dy * blur);
}

float4 __tex2D(sampler2D tex, float4 props, float2 coord, float2 coord_dx, float2 coord_dy, float2 blur, int filter)
{
    if(filter == 6)
        return tex2D(tex, _grid_snap(props, coord),
                       float2(0.0,0.0),
                       float2(0.0,0.0));
    else
        return tex2D(tex, coord,
                       coord_dx * blur,
                       coord_dy * blur);
}

#endif // __TEXTURE2D

#ifndef __MAKE_BASIS
#define __MAKE_BASIS
void __make_basis(const float3 n,const float3 u,const float3 v,out float3 t,out float3 b)
{
    // If u or v a 0, we could create NaNs, try to avoid this.
    float3 c = cross(u,n);
    if(dot(c,c) == 0.0) {
        c = cross(float3(0.0,1.0,0.0),n);
        if(dot(c,c) == 0.0) {
            c = cross(float3(1.0,0.0,0.0), n);
        }
    }
    b = normalize(c);
    t = cross(n,b);
    if(dot(b,v) < 0.0)
        b = -b;
}

#endif // __MAKE_BASIS

#ifndef __PERSPECTIVE_DIVIDE
#define __PERSPECTIVE_DIVIDE
float3 __perspective_divide(float4 pt)
{
    return pt.xyz / pt.w;
}

#endif // __PERSPECTIVE_DIVIDE

#ifndef __DEPENDENT_STATE
#define __DEPENDENT_STATE
void __update_state_origin_or_position(inout State state)
{
    state.direction = state.position - state.origin;
    state.ray_length = length(state.direction);
    state.direction = normalize(state.direction);
} 

#endif // __DEPENDENT_STATE

#ifndef __OBJECT_LABELS
#define __OBJECT_LABELS
uniform int __object_label = 0;
float4 _label_as_color()
{
    int n = __object_label;
    float4 c;
    c.a = float(n / 16777216);
    c.b = float((n % 16777216) / 65536);
    c.g = float((n % 65536) / 256);
    c.r = float(n % 256);
    c /= 255.0;
    return c;
} 

#endif // __OBJECT_LABELS

#ifndef __CLIP_PLANE
#define __CLIP_PLANE
uniform float4 __clip_plane = float4(1.0,1.0,0.0,0.0);

#endif // __CLIP_PLANE

#ifndef __BIT_COUNT
#define __BIT_COUNT
int __bit_count(uint a) {
    int res = 0;
    if (a >= 0x8000) { a -= 0x8000; ++res; }
    if (a >= 0x4000) { a -= 0x4000; ++res; }
    if (a >= 0x2000) { a -= 0x2000; ++res; }
    if (a >= 0x1000) { a -= 0x1000; ++res; }
    if (a >= 0x0800) { a -= 0x0800; ++res; }
    if (a >= 0x0400) { a -= 0x0400; ++res; }
    if (a >= 0x0200) { a -= 0x0200; ++res; }
    if (a >= 0x0100) { a -= 0x0100; ++res; }
    if (a >= 0x8000) { a -= 0x8000; ++res; }
    if (a >= 0x0040) { a -= 0x0040; ++res; }
    if (a >= 0x0020) { a -= 0x0020; ++res; }
    if (a >= 0x0010) { a -= 0x0010; ++res; }
    if (a >= 0x0008) { a -= 0x0008; ++res; }
    if (a >= 0x0004) { a -= 0x0004; ++res; }
    if (a >= 0x0002) { a -= 0x0002; ++res; }
    if (a >= 0x0001) {              ++res; }
    return res;
}
#endif // __BIT_COUNT

#ifndef __BIT_SUBSET
#define __BIT_SUBSET
bool __bit_subset(uint a, uint b)
 {
    if (a >= 0x8000) {
        if (b < 0x8000)
            return false;
        a -= 0x8000;
    }
    if (b >= 0x8000) b -= 0x8000;
    if (a >= 0x4000) {
        if (b < 0x4000)
            return false;
        a -= 0x4000;
    }
    if (b >= 0x4000) b -= 0x4000;
    if (a >= 0x2000) {
        if (b < 0x2000)
            return false;
        a -= 0x2000;
    }
    if (b >= 0x2000) b -= 0x2000;
    if (a >= 0x1000) {
        if (b < 0x1000)
            return false;
        a -= 0x1000;
    }
    if (b >= 0x1000) b -= 0x1000;
    if (a >= 0x0800) {
        if (b < 0x0800)
            return false;
        a -= 0x0800;
    }
    if (b >= 0x0800) b -= 0x0800;
    if (a >= 0x0400) {
        if (b < 0x0400)
            return false;
        a -= 0x0400;
    }
    if (b >= 0x0400) b -= 0x0400;
    if (a >= 0x0200) {
        if (b < 0x0200)
            return false;
        a -= 0x0200;
    }
    if (b >= 0x0200) b -= 0x0200;
    if (a >= 0x0100) {
        if (b < 0x0100)
            return false;
        a -= 0x0100;
    }
    if (b >= 0x0100) b -= 0x0100;
    if (a >= 0x0080) {
        if (b < 0x0080)
            return false;
        a -= 0x0080;
    }
    if (b >= 0x0080) b -= 0x0080;
    if (a >= 0x0040) {
        if (b < 0x0040)
            return false;
        a -= 0x0040;
    }
    if (b >= 0x0040) b -= 0x0040;
    if (a >= 0x0020) {
        if (b < 0x0020)
            return false;
        a -= 0x0020;
    }
    if (b >= 0x0020) b -= 0x0020;
    if (a >= 0x0010) {
        if (b < 0x0010)
            return false;
        a -= 0x0010;
    }
    if (b >= 0x0010) b -= 0x0010;
    if (a >= 0x0008) {
        if (b < 0x0008)
            return false;
        a -= 0x0008;
    }
    if (b >= 0x0008) b -= 0x0008;
    if (a >= 0x0004) {
        if (b < 0x0004)
            return false;
        a -= 0x0004;
    }
    if (b >= 0x0004) b -= 0x0004;
    if (a >= 0x0002) {
        if (b < 0x0002)
            return false;
        a -= 0x0002;
    }
    if (b >= 0x0002) b -= 0x0002;
    if (a >= 0x0001) {
        if (b < 0x0001)
            return false;
        a -= 0x0001;
    }
    if (b >= 0x0001) b -= 0x0001;
    return true;
}
#endif // __BIT_SUBSET

#ifndef __BIT_NOT
#define __BIT_NOT
int __bit_not(int a) {
    return 0xFFFF - a;
}
#endif // __BIT_NOT

#ifndef __BIT_AND
#define __BIT_AND
int __bit_and(uint a, uint b) {
    uint res = a;
    if (a >= 0x8000) {
        a -= 0x8000;
        if (b >= 0x8000) b -= 0x8000; else res -= 0x8000;
    } else if (b >= 0x8000) b -= 0x8000;
    if (a >= 0x4000) {
        a -= 0x4000;
        if (b >= 0x4000) b -= 0x4000; else res -= 0x4000;
    } else if (b >= 0x4000) b -= 0x4000;
    if (a >= 0x2000) {
        a -= 0x2000;
        if (b >= 0x2000) b -= 0x2000; else res -= 0x2000;
    } else if (b >= 0x2000) b -= 0x2000;
    if (a >= 0x1000) {
        a -= 0x1000;
        if (b >= 0x1000) b -= 0x1000; else res -= 0x1000;
    } else if (b >= 0x1000) b -= 0x1000;
    if (a >= 0x0800) {
        a -= 0x0800;
        if (b >= 0x0800) b -= 0x0800; else res -= 0x0800;
    } else if (b >= 0x0800) b -= 0x0800;
    if (a >= 0x0400) {
        a -= 0x0400;
        if (b >= 0x0400) b -= 0x0400; else res -= 0x0400;
    } else if (b >= 0x0400) b -= 0x0400;
    if (a >= 0x0200) {
        a -= 0x0200;
        if (b >= 0x0200) b -= 0x0200; else res -= 0x0200;
    } else if (b >= 0x0200) b -= 0x0200;
    if (a >= 0x0100) {
        a -= 0x0100;
        if (b >= 0x0100) b -= 0x0100; else res -= 0x0100;
    } else if (b >= 0x0100) b -= 0x0100;
    if (a >= 0x0080) {
        a -= 0x0080;
        if (b >= 0x0080) b -= 0x0080; else res -= 0x0080;
    } else if (b >= 0x0080) b -= 0x0080;
    if (a >= 0x0040) {
        a -= 0x0040;
        if (b >= 0x0040) b -= 0x0040; else res -= 0x0040;
    } else if (b >= 0x0040) b -= 0x0040;
    if (a >= 0x0020) {
        a -= 0x0020;
        if (b >= 0x0020) b -= 0x0020; else res -= 0x0020;
    } else if (b >= 0x0020) b -= 0x0020;
    if (a >= 0x0010) {
        a -= 0x0010;
        if (b >= 0x0010) b -= 0x0010; else res -= 0x0010;
    } else if (b >= 0x0010) b -= 0x0010;
    if (a >= 0x0008) {
        a -= 0x0008;
        if (b >= 0x0008) b -= 0x0008; else res -= 0x0008;
    } else if (b >= 0x0008) b -= 0x0008;
    if (a >= 0x0004) {
        a -= 0x0004;
        if (b >= 0x0004) b -= 0x0004; else res -= 0x0004;
    } else if (b >= 0x0004) b -= 0x0004;
    if (a >= 0x0002) {
        a -= 0x0002;
        if (b >= 0x0002) b -= 0x0002; else res -= 0x0002;
    } else if (b >= 0x0002) b -= 0x0002;
    if (a >= 0x0001) {
        a -= 0x0001;
        if (b >= 0x0001) b -= 0x0001; else res -= 0x0001;
    } else if (b >= 0x0001) b -= 0x0001;
    return res;
}
#endif // __BIT_AND

#ifndef __BIT_OR
#define __BIT_OR
int __bit_or(uint a, uint b) {
    uint res = a;
    if (a >= 0x8000) {
        a -= 0x8000;
        if (b >= 0x8000) b -= 0x8000;
    } else if (b >= 0x8000) { b -= 0x8000; res += 0x8000; }
    if (a >= 0x4000) {
        a -= 0x4000;
        if (b >= 0x4000) b -= 0x4000;
    } else if (b >= 0x4000) { b -= 0x4000; res += 0x4000; }
    if (a >= 0x2000) {
        a -= 0x2000;
        if (b >= 0x2000) b -= 0x2000;
    } else if (b >= 0x2000) { b -= 0x2000; res += 0x2000; }
    if (a >= 0x1000) {
        a -= 0x1000;
        if (b >= 0x1000) b -= 0x1000;
    } else if (b >= 0x1000) { b -= 0x1000; res += 0x1000; }
    if (a >= 0x0800) {
        a -= 0x0800;
        if (b >= 0x0800) b -= 0x0800;
    } else if (b >= 0x0800) { b -= 0x0800; res += 0x0800; }
    if (a >= 0x0400) {
        a -= 0x0400;
        if (b >= 0x0400) b -= 0x0400;
    } else if (b >= 0x0400) { b -= 0x0400; res += 0x0400; }
    if (a >= 0x0200) {
        a -= 0x0200;
        if (b >= 0x0200) b -= 0x0200;
    } else if (b >= 0x0200) { b -= 0x0200; res += 0x0200; }
    if (a >= 0x0100) {
        a -= 0x0100;
        if (b >= 0x0100) b -= 0x0100;
    } else if (b >= 0x0100) { b -= 0x0100; res += 0x0100; }
    if (a >= 0x0080) {
        a -= 0x0080;
        if (b >= 0x0080) b -= 0x0080;
    } else if (b >= 0x0080) { b -= 0x0080; res += 0x0080; }
    if (a >= 0x0040) {
        a -= 0x0040;
        if (b >= 0x0040) b -= 0x0040;
    } else if (b >= 0x0040) { b -= 0x0040; res += 0x0040; }
    if (a >= 0x0020) {
        a -= 0x0020;
        if (b >= 0x0020) b -= 0x0020;
    } else if (b >= 0x0020) { b -= 0x0020; res += 0x0020; }
    if (a >= 0x0010) {
        a -= 0x0010;
        if (b >= 0x0010) b -= 0x0010;
    } else if (b >= 0x0010) { b -= 0x0010; res += 0x0010; }
    if (a >= 0x0008) {
        a -= 0x0008;
        if (b >= 0x0008) b -= 0x0008;
    } else if (b >= 0x0008) { b -= 0x0008; res += 0x0008; }
    if (a >= 0x0004) {
        a -= 0x0004;
        if (b >= 0x0004) b -= 0x0004;
    } else if (b >= 0x0004) { b -= 0x0004; res += 0x0004; }
    if (a >= 0x0002) {
        a -= 0x0002;
        if (b >= 0x0002) b -= 0x0002;
    } else if (b >= 0x0002) { b -= 0x0002; res += 0x0002; }
    if (a >= 0x0001) {
        a -= 0x0001;
        if (b >= 0x0001) b -= 0x0001;
    } else if (b >= 0x0001) { b -= 0x0001; res += 0x0001; }
    return res;
}
#endif // __BIT_OR


//
// The following are free parameters of the shader
// that should be set by the application at runtime.
//
texture __msl_max_ToneOpLog_1_env_tex <
    string NodeName = "max_ToneOpLog_1";
    string UIMetaSLName = "env_tex";
    string parameter_source = "max_ToneOpLog_1";
	string UIName = "msl_max_ToneOpLog_1_env_tex";
	string ResourceName = "max_ToneOpLog.exr";
	string ResourceType = "2D";
>;

sampler2D msl_max_ToneOpLog_1_env_tex = sampler_state {
	Texture = <__msl_max_ToneOpLog_1_env_tex>;
	MinFilter = Point;
	MagFilter = Point;
	MipFilter = Point;
	Filter = MIN_MAG_MIP_POINT;
};

float4 msl_max_ToneOpLog_1_env_tex_props;

bool msl_max_ToneOpLog_1_active
<
    string UIName = "Active";
    string NodeName = "max_ToneOpLog_1";
    string UIMetaSLName = "active";
    string parameter_source = "max_ToneOpLog_1";
> = true;
float msl_max_ToneOpLog_1_physicalScale
<
    string UIName = "PhysicalScale";
    float UIMin = 1.0f;
    float UIMax = 3000.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_ToneOpLog_1";
    string UIMetaSLName = "physicalScale";
    string parameter_source = "max_ToneOpLog_1";
> = 1500.0f;
bool msl_max_ToneOpLog_1_chromaticAdaptation
<
    string UIName = "ChromaticAdaptation";
    string NodeName = "max_ToneOpLog_1";
    string UIMetaSLName = "chromaticAdaptation";
    string parameter_source = "max_ToneOpLog_1";
> = false;
bool msl_max_ToneOpLog_1_colorDifferentiation
<
    string UIName = "ColorDifferentiation";
    string NodeName = "max_ToneOpLog_1";
    string UIMetaSLName = "colorDifferentiation";
    string parameter_source = "max_ToneOpLog_1";
> = false;
float4 msl_max_ToneOpLog_1_whiteColor
<
    string UIName = "WhiteColor";
    float4 UIMin = {0.0f,0.0f,0.0f,0.0f};
    float4 UIMax = {1.0f,1.0f,1.0f,1.0f};
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_ToneOpLog_1";
    string UIMetaSLName = "whiteColor";
    string parameter_source = "max_ToneOpLog_1";
> = {1.0f,1.0f,1.0f,1.0f};
float msl_max_ToneOpLog_1_brightness
<
    string UIName = "Brightness";
    float UIMin = 1.0f;
    float UIMax = 100.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_ToneOpLog_1";
    string UIMetaSLName = "brightness";
    string parameter_source = "max_ToneOpLog_1";
> = 65.0f;
float msl_max_ToneOpLog_1_contrast
<
    string UIName = "Contrast";
    float UIMin = 1.0f;
    float UIMax = 100.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_ToneOpLog_1";
    string UIMetaSLName = "contrast";
    string parameter_source = "max_ToneOpLog_1";
> = 50.0f;
float msl_max_ToneOpLog_1_midTones
<
    string UIName = "MidTones";
    float UIMin = 0.0f;
    float UIMax = 1.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_ToneOpLog_1";
    string UIMetaSLName = "midTones";
    string parameter_source = "max_ToneOpLog_1";
> = 1.0f;
bool msl_max_ToneOpLog_1_daylight
<
    string UIName = "Daylight";
    string NodeName = "max_ToneOpLog_1";
    string UIMetaSLName = "daylight";
    string parameter_source = "max_ToneOpLog_1";
> = true;
bool msl_max_ToneOpLog_1_exterior
<
    string UIName = "Exterior";
    string NodeName = "max_ToneOpLog_1";
    string UIMetaSLName = "exterior";
    string parameter_source = "max_ToneOpLog_1";
> = true;
bool msl_max_ToneOpLog_1_useLegacyAlgorithm
<
    string UIName = "UseLegacyAlgorithm";
    string NodeName = "max_ToneOpLog_1";
    string UIMetaSLName = "useLegacyAlgorithm";
    string parameter_source = "max_ToneOpLog_1";
> = false;
/*
	max_ToneOpLog_1_active:
		bool msl_max_ToneOpLog_1_active = true
	max_ToneOpLog_1_brightness:
		float msl_max_ToneOpLog_1_brightness = 65.000000
	max_ToneOpLog_1_chromaticAdaptation:
		bool msl_max_ToneOpLog_1_chromaticAdaptation = false
	max_ToneOpLog_1_colorDifferentiation:
		bool msl_max_ToneOpLog_1_colorDifferentiation = false
	max_ToneOpLog_1_contrast:
		float msl_max_ToneOpLog_1_contrast = 50.000000
	max_ToneOpLog_1_daylight:
		bool msl_max_ToneOpLog_1_daylight = true
	max_ToneOpLog_1_exterior:
		bool msl_max_ToneOpLog_1_exterior = true
	max_ToneOpLog_1_midTones:
		float msl_max_ToneOpLog_1_midTones = 1.000000
	max_ToneOpLog_1_physicalScale:
		float msl_max_ToneOpLog_1_physicalScale = 1500.000000
	max_ToneOpLog_1_useLegacyAlgorithm:
		bool msl_max_ToneOpLog_1_useLegacyAlgorithm = false
	max_ToneOpLog_1_whiteColor:
		Color msl_max_ToneOpLog_1_whiteColor = float4(1.000000,1.000000,1.000000,1.000000)
 */


//
// The following are parameters representing
// non-varying state variables referenced by the shader.
// These should be set by the application at runtime.
//

float4x4 __ndc_to_camera : ProjectionInverse
<
    string UIWidget = "none";
>;
float4x4 __camera_to_ndc : Projection
<
    string UIWidget = "none";
>;
bool __orthographic : Orthographic= false;
float4x4 __object_to_world : World
<
    string UIWidget = "none";
>;
float4x4 __camera_to_world : ViewInverse
<
    string UIWidget = "none";
>;

//
// The following are parameters representing
// non-varying non-state variables referenced by the shader.
// These should be set by the application at runtime.
//
float4x4 __internal_to_light;
float4x4 __light_to_internal;
float4 __light_texture_coordinate[4];
float3 __light_texture_tangent_u[4];
float3 __light_texture_tangent_v[4];
float __wavelength_base[3];
float __wavelength_sample[3];
int __light_normal_mode;
float __light_scaling_factor;


//
// The App2vert structure defines the vertex attributes
// used by the vertex shader.
// The application should supply a vertex stream
// containing these elements.
//
struct App2vert
{
    float3 position : POSITION;
    float3 normal : NORMAL;
    float4 texcoord0 : TEXCOORD0;
    float4 texcoord1 : TEXCOORD1;
    float4 texcoord2 : TEXCOORD2;
    float4 texcoord3 : TEXCOORD3;
};

//
// The Vert2frag_out structure defines values output by the vertex shader.
//
struct Vert2frag_out
{
    float4 hpos : POSITION;
    float4 tex_coord[4] : TEXCOORD0;
    float3 position : TEXCOORD4;
    float3 normal : TEXCOORD5;
};

//
// The Vert2frag_in structure defines values used by the fragment shader.
//
struct Vert2frag_in
{
    float4 hpos : POSITION1;
    float4 tex_coord[4] : TEXCOORD0;
    float3 position : TEXCOORD4;
    float3 normal : TEXCOORD5;
};

//
// This function is the main method of the vertex shader.
//
Vert2frag_out vertex_main(
    App2vert vs_in)
{
    Vert2frag_out vs_out;
    vs_out.position = mul(float4(vs_in.position,1.0),__ndc_to_camera).xyz;
    vs_out.hpos = float4(vs_in.position,1.0);
    vs_out.normal = mul((float3x3)__camera_to_ndc,vs_in.normal);
    vs_out.tex_coord[0] = vs_in.texcoord0;
    vs_out.tex_coord[1] = vs_in.texcoord1;
    vs_out.tex_coord[2] = vs_in.texcoord2;
    vs_out.tex_coord[3] = vs_in.texcoord3;
    return vs_out;
}

//
// Declaration of final output type. For MRT, this is a struct.
//
typedef float4 FS_OUT;

float max_ToneOpLog_calcBrightness_4029_49(
    inout State state,
    in float4 msl_value)
{
    return ((abs(msl_value.r) * 0.263f) + (abs(msl_value.g) * 0.655f)) + (abs(msl_value.b) * 0.082f);
}

float max_ToneOpLog_approximateScotopicLuminance_4029_47(
    inout State state,
    float4 msl_value)
{
    return ((0.062f * msl_value.r) + (0.608f * msl_value.g)) + (0.330f * msl_value.b);
}

int max_ToneOpLog_max_ToneOpLog_ScaleToRGB_4029_51(
    inout State state,
    inout float4 msl_local_result,
    in float msl_inst_m_inputScaleFactor,
    in bool msl_inst_chromaticAdaptation,
    in float4 msl_inst_m_whiteConstancyFactor,
    in bool msl_inst_colorDifferentiation,
    in bool msl_inst_mapComponentsIndependently,
    in float msl_inst_m_a,
    in float msl_inst_m_b,
    in float msl_inst_m_c)
{
    float4 msl_col = float4(0.0f,0.0f,0.0f,0.0f);
    msl_col.r = (msl_local_result.r * msl_inst_m_inputScaleFactor);
    msl_col.g = (msl_local_result.g * msl_inst_m_inputScaleFactor);
    msl_col.b = (msl_local_result.b * msl_inst_m_inputScaleFactor);
    msl_col.a = msl_local_result.a;
    if(msl_inst_chromaticAdaptation)
    {
        msl_col.r *= msl_inst_m_whiteConstancyFactor.r;
        msl_col.g *= msl_inst_m_whiteConstancyFactor.g;
        msl_col.b *= msl_inst_m_whiteConstancyFactor.b;
    }
    float msl_luminance = max_ToneOpLog_calcBrightness_4029_49(state,msl_col);
    if(msl_inst_colorDifferentiation && (msl_luminance < 5.62f))
    {
        float msl_sluminance = max_ToneOpLog_approximateScotopicLuminance_4029_47(state,msl_col);
        if(msl_luminance <= 5.62e-3f)
        {
            msl_col.r = msl_sluminance;
            msl_col.g = msl_sluminance;
            msl_col.b = msl_sluminance;
        }
        else
        {
            float msl_w = (msl_luminance - 5.62e-3f) / 5.61438f;
            msl_col.r *= msl_w;
            msl_col.g *= msl_w;
            msl_col.b *= msl_w;
            msl_col.r += (msl_sluminance * (1.0f - msl_w));
            msl_col.g += (msl_sluminance * (1.0f - msl_w));
            msl_col.b += (msl_sluminance * (1.0f - msl_w));
        }
    }
    if(msl_inst_mapComponentsIndependently)
    {
        if(msl_col.r > 0.0f)
        {
            msl_col.r *= (msl_inst_m_a / ((msl_inst_m_b * msl_col.r) + msl_inst_m_c));
        }
        else
        {
            msl_col.r = 0.0f;
        }
        if(msl_col.g > 0.0f)
        {
            msl_col.g *= (msl_inst_m_a / ((msl_inst_m_b * msl_col.g) + msl_inst_m_c));
        }
        else
        {
            msl_col.g = 0.0f;
        }
        if(msl_col.b > 0.0f)
        {
            msl_col.b *= (msl_inst_m_a / ((msl_inst_m_b * msl_col.b) + msl_inst_m_c));
        }
        else
        {
            msl_col.b = 0.0f;
        }
        msl_local_result = msl_col;
    }
    else
    {
        if(msl_luminance > 0.0f)
        {
            float msl_I = msl_inst_m_a / ((msl_inst_m_b * msl_luminance) + msl_inst_m_c);
            msl_col.r *= msl_I;
            msl_col.g *= msl_I;
            msl_col.b *= msl_I;
            msl_local_result = msl_col;
        }
        else
        {
            msl_local_result.r = 0.0f;
            msl_local_result.g = 0.0f;
            msl_local_result.b = 0.0f;
        }
    }
    return 0;
}

int max_ToneOpLog_main_4029_13(
    inout State state,
    sampler2D msl_env_tex, float4 msl_env_tex_props,
    float2 msl_texture_uv,
    bool msl_active,
    float msl_physicalScale,
    bool msl_chromaticAdaptation,
    bool msl_colorDifferentiation,
    float4 msl_whiteColor,
    float msl_brightness,
    float msl_contrast,
    float msl_midTones,
    bool msl_daylight,
    bool msl_exterior,
    bool msl_useLegacyAlgorithm,
    out float4 msl_result)
{
    {
        msl_result = float4(0.0f,0.0f,0.0f,0.0f);
        float3 msl_v = mul((state.direction),(float3x3)(float4x4(1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1)));
        float2 msl_texture;
        msl_texture.x = (0.5f + msl_v.x);
        msl_texture.y = (0.5f - msl_v.y);
        msl_result = __tex2D(msl_env_tex,msl_texture_uv);
        float msl_D3DX_16F_MAX = 6.550400e+004f;
        if(msl_result.r > msl_D3DX_16F_MAX)
        {
            msl_result.r = msl_D3DX_16F_MAX;
        }
        if(msl_result.g > msl_D3DX_16F_MAX)
        {
            msl_result.g = msl_D3DX_16F_MAX;
        }
        if(msl_result.b > msl_D3DX_16F_MAX)
        {
            msl_result.b = msl_D3DX_16F_MAX;
        }
        if(msl_active)
        {
            bool msl_applyToneOp = true;
            if(msl_applyToneOp)
            {
                float msl_inst_m_inputScaleFactor = msl_physicalScale / 3.14159265358979323846f;
                bool msl_inst_mapComponentsIndependently = !msl_useLegacyAlgorithm;
                float msl_bb = (msl_brightness < 0.0f) ? 0.0f : (msl_brightness * 0.7f);
                float msl_ordersOfMag = 5.0f;
                float msl_powerBot = (msl_daylight && msl_exterior) ? 4.0f : 2.0f;
                float msl_res = 100.0f / msl_ordersOfMag;
                float msl_mag = floor((50.0f / msl_res));
                float msl_power = (((msl_bb / 20.0f) - msl_ordersOfMag) - msl_powerBot) + msl_mag;
                float msl_stepsize = 9.0f / msl_res;
                float msl_step = 50.0f - (msl_mag * msl_res);
                float msl_inst_m_c = (0.02f * msl_contrast) * 2.0f;
                float msl_inst_m_b = pow(10.0f,msl_power) * (1.0f + (msl_stepsize * msl_step));
                float msl_inst_m_a = msl_inst_m_b * (1.0f + msl_inst_m_c);
                msl_inst_m_c /= pow(2.0f,(msl_midTones - 1.0f));
                msl_inst_m_b *= 3.14159265358979323846f;
                float4 msl_inst_m_whiteConstancyFactor = msl_whiteColor;
                if(msl_chromaticAdaptation)
                {
                    float msl_luminance = max_ToneOpLog_calcBrightness_4029_49(state,msl_inst_m_whiteConstancyFactor);
                    msl_inst_m_whiteConstancyFactor.r = ((msl_inst_m_whiteConstancyFactor.r > 0.001f) ? (msl_luminance / msl_inst_m_whiteConstancyFactor.r) : (msl_luminance / 0.001f));
                    msl_inst_m_whiteConstancyFactor.g = ((msl_inst_m_whiteConstancyFactor.g > 0.001f) ? (msl_luminance / msl_inst_m_whiteConstancyFactor.g) : (msl_luminance / 0.001f));
                    msl_inst_m_whiteConstancyFactor.b = ((msl_inst_m_whiteConstancyFactor.b > 0.001f) ? (msl_luminance / msl_inst_m_whiteConstancyFactor.b) : (msl_luminance / 0.001f));
                }
                max_ToneOpLog_max_ToneOpLog_ScaleToRGB_4029_51(state,msl_result,msl_inst_m_inputScaleFactor,msl_chromaticAdaptation,msl_inst_m_whiteConstancyFactor,msl_colorDifferentiation,msl_inst_mapComponentsIndependently,msl_inst_m_a,msl_inst_m_b,msl_inst_m_c);
            }
        }
    }
    return 0;
}

//
// The following method is the root function of the shader graph
//
float4 max_ToneOpLog_1_eval(State state, out FS_OUT eval_out)
{
    // primary output: 
    float4 msl_result;
    max_ToneOpLog_main_4029_13(state,msl_max_ToneOpLog_1_env_tex,msl_max_ToneOpLog_1_env_tex_props,(state.tex_coord)[0].xy,msl_max_ToneOpLog_1_active,msl_max_ToneOpLog_1_physicalScale,msl_max_ToneOpLog_1_chromaticAdaptation,msl_max_ToneOpLog_1_colorDifferentiation,msl_max_ToneOpLog_1_whiteColor,msl_max_ToneOpLog_1_brightness,msl_max_ToneOpLog_1_contrast,msl_max_ToneOpLog_1_midTones,msl_max_ToneOpLog_1_daylight,msl_max_ToneOpLog_1_exterior,msl_max_ToneOpLog_1_useLegacyAlgorithm,msl_result);
    eval_out = msl_result;
    return msl_result;
}

//
// This function is the main method of the fragment shader.
// It initializes the values in the state structure
// that are used by nodes in the shader graph
// and produces the final result of the shader.
//
FS_OUT fragment_main(
    Vert2frag_in fs_in) : COLOR
{
    State state;
    state.position = fs_in.position;
    state.normal = normalize(fs_in.normal);
    state.tex_coord = fs_in.tex_coord;
    state.origin = __orthographic ? float3(state.position.x, state.position.y, 0) : 0;
    state.ray_length = __orthographic ? abs(state.position.z) : length(state.position);
    state.direction = __orthographic ? float3(0.0,0.0,-1.0) : state.position/state.ray_length;

    FS_OUT eval_out;  // multiple shader outputs
    float4 primary_out;  // primary shader output
    primary_out = max_ToneOpLog_1_eval(state,eval_out);
    FS_OUT fs_out;
    fs_out = primary_out;
    return fs_out;
}

//
// The following define the default technique and pass of the effect.
//
technique T0
<
    string Script = "Pass=P0;";
>
{
    pass P0
    <
    string Script = "Draw=Buffer;";
        >
        {
            VertexShader = compile vs_3_0 vertex_main();
            PixelShader  = compile ps_3_0 fragment_main();
        }
    }

